﻿<%@ Page Title="Patient Image Details" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="PatientImageDetails.aspx.cs" Inherits="PatientImageDetails" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="ContentHead" ContentPlaceHolderID="head" runat="server">
    <link href="styles/Imaging.css" rel="stylesheet" />
</asp:Content>

<asp:Content ID="ContentMain" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <telerik:RadScriptManager runat="server" ID="RadScriptManagerMain" />

    <telerik:RadCodeBlock runat="server">

        <script type ="text/javascript">

            $(document).ready(function () {

                var imageTypeSelection = $('#<%=RadComboBoxImageType.ClientID %>').val();
                if (imageTypeSelection.indexOf('Other') !== -1) {
                    $('#<%=RadTextBoxOtherImageType.ClientID%>').prop('disabled', false);
                }

                var imageReasonSelection = $('#<%=RadComboBoxImagingReasons.ClientID %>').val();
                if (imageReasonSelection.indexOf('Other') !== -1) {
                    $('#<%=RadTextBoxOtherImageReason.ClientID%>').prop('disabled', false);
                }

            }); // $(document).ready(function ()

            function RadComboBoxImageTypeOnClientLoad(sender) {

                var item = sender.get_selectedItem();
                if (item) {
                    var text = item.get_text();
                    if (text) {
                        handleImagingTypeOther(text);
                    }
                } else {
                    toggleEnabled(false, '<%=RadTextBoxOtherImageType.ClientID%>');
                }
            }

            function RadComboBoxImageTypeOnClientSelectedIndexChanged(sender, args) {

                var text = args.get_item().get_text();
                if (text) {
                    handleImagingTypeOther(text);
                }
            }

            var handleImagingTypeOther = function (text) {

                toggleEnabled(text.indexOf('Other') !== -1, '<%=RadTextBoxOtherImageType.ClientID%>');
            }

            function RadComboBoxImagingReasonsOnClientLoad(sender) {

                handleImagingReasonOther(sender);
            }

            function RadComboBoxImagingReasonsOnClientItemChecked(sender, args) {

                var combo = $find("<%= RadComboBoxImagingReasons.ClientID %>");

                handleImagingReasonOther(combo);
            }

            var handleImagingReasonOther = function (combo) {

                var otherReasonIndex = 5;
                var index = 0;

                var items = combo.get_items();
                if (items) {

                    items.forEach(function (item) {

                        if (index++ == otherReasonIndex) {

                            toggleEnabled(item.get_checked(), '<%=RadTextBoxOtherImageReason.ClientID%>');
                        }
                    });
                }
            }

            var toggleEnabled = function (enabledExpression, radObjectId) {

                var id = $('#' + radObjectId);
                
                if (enabledExpression) {

                    $(id).prop('disabled', false);

                } else {

                    $(id).prop('disabled', true);
                    $(id).val('');
                }
            }


        </script>
        
    </telerik:RadCodeBlock>

    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Patients > Patient Lookup > Imaging > Image Details > " />
    </div> 

    <!-- ********************************************************************************************** -->
    <!-- Patient Information -->
    <!-- ******************* -->
    <div class="va-boxed-content">
        <div class="va-bold underline">
            <asp:Label SkinID="DataLabel" ID = "LabelPatientInformation" runat="server" Text="Patient Information" />
        </div>

        <table summary="Table is used for layout purposes" style="width:100%">
            <tr>
                <!-- Patient Name -->
                <td class="style1">
                    <asp:Label 
                        runat="server" 
                        ID="LabelPatientName" 
                        AssociatedControlID="LabelPatientNameData" 
                        SkinID="DataLabel">
                        Patient Name:
                    </asp:Label>
                </td>
                <td class="style2">
                    <asp:Label 
                        runat="server" 
                        ID="LabelPatientNameData" 
                        SkinID="DataLabel" >
                    </asp:Label>
                </td>
                <!-- Patient SSN -->
                <td class="style1" >
                    <asp:Label 
                        runat="server" 
                        ID="LabelPatientSsn" 
                        AssociatedControlID="LabelPatientSsnData" 
                        SkinID = "DataLabel">
                        Patient SSN:
                    </asp:Label>
                </td>
                <td class="style2" >
                        <asp:Label 
                            runat="server" 
                            ID="LabelPatientSsnData" 
                            SkinID="DataLabel" >
                        </asp:Label>
                </td>
            </tr>
            <tr>
                <!-- System Identified Possible Fragment -->
                <td class="style1">
                    <asp:Label 
                        runat="server" 
                        ID="LabelSystemIDFragment" 
                        AssociatedControlID="LabelSystemIDFragmentData" 
                        SkinID = "DataLabel">
                        System Identified Possible Fragment:
                    </asp:Label>
                </td>
                <td class="style2">
                    <asp:Label 
                        runat="server" 
                        ID="LabelSystemIDFragmentData" 
                        SkinID = "DataLabel" />
                </td>
                <!-- Study Description -->
                <td class="style1">
                    <asp:Label 
                        runat="server" 
                        ID="LabelStudyDescription" 
                        AssociatedControlID="LabelStudyDescriptionData" 
                        SkinID = "DataLabel">
                        Study Description:
                    </asp:Label>
                </td>
                <td class="style2">
                    <asp:Label 
                        runat="server" 
                        ID="LabelStudyDescriptionData" 
                        SkinID = "DataLabel" />
                </td>
            </tr>
        </table>
    </div>

    <br />
    <br />

    <!-- ********************************************************************************************** -->
    <!-- Image Details -->
    <!-- ************* -->
    <div class="va-boxed-content">
        <div class="va-bold underline">
            <asp:Label SkinID="DataLabel" ID = "LabelImageDetails" runat="server" Text="Image Details" />
        </div>
        <br />

        <div>
            <!-- Image Type -->
            <div class="inline-left">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelImageType"
                    AssociatedControlID="RadComboBoxImageType"
                    CssClass="label-image-details"
                    Text="Image Type: "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadComboBox 
                    runat="server"
                    role="application"
                    ID="RadComboBoxImageType" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Image Type"
                    EmptyMessage="Select Image Type"
                    Width="400" 
                    OnClientLoad="RadComboBoxImageTypeOnClientLoad"
                    OnClientSelectedIndexChanged="RadComboBoxImageTypeOnClientSelectedIndexChanged">
                </telerik:RadComboBox>
            </div>

            <!-- Image Type Other -->
            <div class="inline-right">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelOtherImageType"
                    AssociatedControlID="RadTextBoxOtherImageType"
                    CssClass="label-image-details"
                    Text="Other Image Type: "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadTextBox
                    runat="server" 
                    role="application"
                    ID="RadTextBoxOtherImageType" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Other Image Type"
                    ToolTip="Select Other Image Type"
                    TextMode="MultiLine"
                    Rows="3"
                    Width="400">
            </telerik:RadTextBox>
            </div>
        </div>
        <br />

        <div>
            <!-- Reason(s) For Imaging -->
            <div class="inline-left">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelImagingReasons"
                    AssociatedControlID="RadComboBoxImagingReasons"
                    CssClass="label-image-details"
                    Text="Reason(s) For Imaging: "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadComboBox 
                    runat="server"
                    role="application"
                    ID="RadComboBoxImagingReasons" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Reason(s) For Imaging"
                    EmptyMessage="Select Reason(s) For Imaging"
                    CheckBoxes="true"  
                    Width="400"
                    OnClientLoad="RadComboBoxImagingReasonsOnClientLoad"
                    OnClientItemChecked ="RadComboBoxImagingReasonsOnClientItemChecked">
                </telerik:RadComboBox>
            </div>

            <!-- Image Reason Other -->
            <div class="inline-right">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelOtherImageReason"
                    AssociatedControlID="RadTextBoxOtherImageReason"
                    CssClass="label-image-details"
                    Text="Other Image Reason: "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadTextBox
                    runat="server" 
                    role="application"
                    ID="RadTextBoxOtherImageReason" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Other Image Reason"
                    ToolTip="Select Other Image Reason"
                    TextMode="MultiLine"
                    Rows="3"
                    Width="400" >
            </telerik:RadTextBox>
            </div>
        </div>
        <br />

        <div>
            <!-- Body Part Imaged -->
            <div class="inline-left">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelBodyPartImaged"
                    AssociatedControlID="RadComboBoxBodyPartImaged"
                    CssClass="label-image-details"
                    Text="Body Part(s) Imaged: "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadComboBox 
                    runat="server" 
                    role="application"
                    ID="RadComboBoxBodyPartImaged" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Body Part(s) Imaged"
                    EmptyMessage="Select Body Part(s) Imaged"
                    CheckBoxes="true"  
                    Width="400">
                </telerik:RadComboBox>
            </div>

            <!-- Number of Fragments -->
            <div class="inline-right">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelFragmentCount"
                    AssociatedControlID="RadComboBoxFragmentCount"
                    CssClass="label-image-details"
                    Text="Number of Fragments: "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadComboBox 
                    runat="server" 
                    role="application"
                    ID="RadComboBoxFragmentCount" 
                    RenderMode="Lightweight"
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Number of Fragments"
                    EmptyMessage="Select Fragments Count"
                    Width="200">
                </telerik:RadComboBox>
            </div>
        </div>
        <br />

        <div>
            <!-- Largest Fragment Length-->
            <div class="inline-left-small">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelLargestFragmentLength"
                    AssociatedControlID="RadTextBoxLargestFragmentLength"
                    CssClass="label-image-details"
                    Text="Largest Fragment Length (mm): "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadTextBox
                    runat="server"
                    role="application"
                    ID="RadTextBoxLargestFragmentLength" 
                    RenderMode="Lightweight" 
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Largest Fragment Length"
                    Width="200" 
                    EmptyMessage="Enter fragment length in mm.">
                </telerik:RadTextBox>  
            </div>

            <!-- Largest Fragment Width-->
            <div class="inline-right">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelLargestFragmentWidth"
                    AssociatedControlID="RadTextBoxLargestFragmentWidth"
                    CssClass="label-image-details"
                    Text="Largest Fragment Width (mm): "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadTextBox
                    runat="server"
                    role="application"
                    ID="RadTextBoxLargestFragmentWidth" 
                    RenderMode="Lightweight" 
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Largest Fragment Width"
                    Width="200" 
                    EmptyMessage="Enter fragment width in mm.">
                </telerik:RadTextBox>
            </div>
        </div>
        <br />

        <div>
            <!-- Smallest Fragment Length-->
            <div class="inline-left-small">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelSmallestFragmentLength"
                    AssociatedControlID="RadTextBoxSmallestFragmentLength"
                    CssClass="label-image-details"
                    Text="Smallest Fragment Length (mm): "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadTextBox
                    runat="server"
                    role="application"
                    ID="RadTextBoxSmallestFragmentLength" 
                    RenderMode="Lightweight" 
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Smallest Fragment Length"
                    Width="200" 
                    EmptyMessage="Enter fragment length in mm.">
                </telerik:RadTextBox>  
            </div>

            <!-- Smallest Fragment Width-->
            <div class="inline-right">
                <telerik:RadLabel 
                    runat="server"
                    ID="RadLabelSmallestFragmentWidth"
                    AssociatedControlID="RadTextBoxSmallestFragmentWidth"
                    CssClass="label-image-details"
                    Text="Smallest Fragment Width (mm): "
                    Width="250" >
                </telerik:RadLabel>
                <telerik:RadTextBox
                    runat="server"
                    role="application"
                    ID="RadTextBoxSmallestFragmentWidth" 
                    RenderMode="Lightweight" 
                    AccessibilityMode="true"
                    EnableAriaSupport="true"
                    AriaSettings-Label="Smallest Fragment Width"
                    Width="200" 
                    EmptyMessage="Enter fragment width in mm.">
                </telerik:RadTextBox>
            </div>
        </div>
        <br />

        <!-- Was a Fragment Documented -->
        <div>
            <telerik:RadLabel 
                runat="server"
                ID="RadLabelFragmentDocumented"
                AssociatedControlID="RadComboBoxFragmentDocumented"
                CssClass="label-image-details"
                Text="Fragment Documented: "
                Width="250" >
            </telerik:RadLabel>
            <telerik:RadComboBox 
                runat="server"  
                role="application"
                ID="RadComboBoxFragmentDocumented" 
                RenderMode="Lightweight" 
                AccessibilityMode="true"
                EnableAriaSupport="true"
                AriaSettings-Label="Fragment Documented"
                Width="200" 
                EmptyMessage="(Select a Value)">
            </telerik:RadComboBox>
        </div>
         <br />

        <!-- Reviewed -->
        <div>
            <telerik:RadLabel 
                runat="server"
                ID="RadLabelReviewed"
                AssociatedControlID="RadComboBoxReviewed"
                CssClass="label-image-details"
                Text="Reviewed: "
                Width="250" >
            </telerik:RadLabel>
            <telerik:RadComboBox 
                runat="server"
                role="application"
                ID="RadComboBoxReviewed" 
                RenderMode="Lightweight" 
                AccessibilityMode="true"
                EnableAriaSupport="true"
                AriaSettings-Label="Reviewed"
                Width="200" 
                EmptyMessage="(Select a Value)">
            </telerik:RadComboBox>
        </div>
        <br />

        <!-- Include in report -->
        <div>
            <telerik:RadLabel 
                runat="server"
                ID="RadLabelIncludeInReport"
                AssociatedControlID="RadComboBoxIncludeInReport"
                CssClass="label-image-details"
                Text="Include In Report: "
                Width="250" >
            </telerik:RadLabel>
            <telerik:RadComboBox 
                runat="server"  
                role="application"
                ID="RadComboBoxIncludeInReport" 
                RenderMode="Lightweight"
                AccessibilityMode="true"
                EnableAriaSupport="true"
                AriaSettings-Label="Include In Report"
                Width="200" 
                EmptyMessage="(Select a Value)">
            </telerik:RadComboBox>
        </div>
        <br />

        <!-- Comments -->
        <div>
            <telerik:RadLabel 
                runat="server"
                ID="RadLabelComments"
                AssociatedControlID="RadTextBoxComments"
                CssClass="label-image-details"
                Text="Comments: "
                Width="250" >
            </telerik:RadLabel>
        </div>
        <br />

        <div>
            <telerik:RadTextBox 
                runat="server" 
                role="application"
                ID="RadTextBoxComments" 
                RenderMode="Lightweight" 
                AccessibilityMode="true"
                EnableAriaSupport="true"
                AriaSettings-Label="Comments"
                Rows="6"
                Width="100%" 
                TextMode="MultiLine"
                EmptyMessage="Enter Comments">
            </telerik:RadTextBox>
        </div>
            
    </div>   

    <br />
    <br />

    <!-- ********************************************************************************************** -->
    <!-- Buttons -->
    <!-- ******* -->
    <table width="100%">
        <tr>
            <td align="left">
                <asp:Button 
                    runat = "server" 
                    ID = "BackButton" 
                    Text = "Back" 
                    Width = "130px" 
                    UseSubmitBehavior = "true" 
                    CausesValidation="false"
                    ToolTip="Return to previous page."/>
                <asp:Button 
                    runat = "server" 
                    ID = "SaveButton" 
                    Text = "Save" 
                    Width = "130px" 
                    OnClick = "SaveButton_Click" 
                    UseSubmitBehavior = "true" 
                    ToolTip="" />
            </td>
        </tr>
    </table> 
    <br />
    <br />

</asp:Content>


